# Include file for GURPS aging.

# Copyright  2003 Alter Ego Software, Inc.. All Rights Reserved.

var characterDied;

# Return non-zero if the character dies.

sub DoAgingRolls(age, agingRoll, medicalTL, failures) {
	var ST, HT, DX, IQ, Fatigue, Hits;
	var stDec, htDec, dxDec, iqDec;
	var fatDec, hitsDec;

	ST = $@ST;
	HT = $@HT;
	DX = $@DX;
	IQ = $@IQ;
	Fatigue = $@x_st;
	Hits = $@x_ht;

	stDec = 0;
	dxDec = 0;
	iqDec = 0;
	htDec = 0;
	fatDec = 0;
	hitsDec = 0;

	characterDied = 0;

	var newVal;

	newVal = AgingRoll("ST", ST, agingRoll, age, failures);
	stDec = newVal - ST;
	if (stDec < 0)
		if ($@RevFatHits)
			if (!$@Hits1Required)
				hitsDec = stDec;
				ReduceDepAtt("Hit Point", Hits, $@x_ht, "x_ht", stDec);
			endif
		elseif (!$@FatigueBOIQ)
			fatDec = stDec;
			ReduceDepAtt("Fatigue", Fatigue, $@x_st, "x_st", stDec);
		endif
	endif

	if (!characterDied)
		newVal = AgingRoll("DX", DX, agingRoll, age, failures);
		dxDec = newVal - DX;
	endif

	if (!characterDied)
		newVal = AgingRoll("IQ", IQ, agingRoll, age, failures);
		iqDec = newVal - IQ;
		if ($@FatigueBOIQ)
			fatDec = iqDec;
			ReduceDepAtt("Fatigue", Fatigue, $@x_st, "x_st", iqDec);
		endif
	endif

	if (!characterDied)
		newVal = AgingRoll("HT", HT, agingRoll, age, failures);
		htDec = newVal - HT;
		if (htDec < 0)
			if ($@RevFatHits)
				fatDec = htDec;
				ReduceDepAtt("Fatigue", Fatigue, $@x_st, "x_st", htDec);
			else
				if (!$@Hits1Required)
					hitsDec = htDec;
					ReduceDepAtt("Hit Point", Hits, $@x_ht, "x_ht", htDec);
				endif
			endif
		endif
	endif

	if (stDec or dxDec or iqDec or htDec)
		add History.Aging;
		option Age = age;
		option Result = "$$age: ST $$stDec, DX $$dxDec, IQ $$iqDec, HT $$htDec";
		option ST Decrease = stDec;
		option DX Decrease = dxDec;
		option IQ Decrease = iqDec;
		option HT Decrease = htDec;
		option Fatigue Decrease = fatDec;
		option Hit Point Decrease = hitsDec;
	endif

	return characterDied;
}


sub ReduceDepAtt(name, oldValue, curValue, variable, decline) {
	if (decline)
		item (Disadvantages, "Age")
			option $$name Decrease = integer(optValue("$$name Decrease")) + decline;
		enditem
		if (value = curValue)
			Main.$$variable = oldValue + decline;
		endif
	endif
}

sub AgingRoll(name, attribute, agingRoll, age, failures) {
	if (attribute <= 0)
		return attribute;
	endif

	var failed, result, original, btn, n;
	var decline = 0;

	result = rolldice("3d6");
	original = attribute;
	failed = 0;
	if (result >= 17)
		decline = 2;
	elseif (result > agingRoll)
		decline = 1;
	endif

	if (decline != 0)
		attribute = attribute - decline;
		$$name = attribute;
		n = addElement(failures, "Age $$age: $$name $$original -> $$attribute (roll $$result/$$agingRoll)");
		Main.$$name = attribute;
		item (Disadvantages, "Age")
			option $$name Decrease = optValue("$$name Decrease") - decline;
		enditem
		if (attribute <= 0)
			characterDied = 1;
		endif
	endif

	return attribute;
}


# Reset the named attribute to the original value.

sub ResetAtt(name, value, bonus, decrease) {
	if (value = bonus)
		# When a value equals its bonus, that means the value itself
		# is 0.
		value = 0;
	else
		value = value + bonus;
	endif
	Main.$$name = value - decrease;
	option $$name Decrease = optValue('$$name Decrease') - decrease;
}


# Reverse effects of aging rolls recorded in history.

sub ReverseAging(age) {
	var stDec, htDec, dxDec, iqDec, fatDec, hitsDec;

	stDec = 0;
	dxDec = 0;
	iqDec = 0;
	htDec = 0;
	fatDec = 0;
	hitsDec = 0;

	foreach (History)
		if (inCategory("Aging"))
			if (float(@Age) > age)
				stDec = stDec + integer(@`ST Decrease`);
				dxDec = dxDec + integer(@`DX Decrease`);
				iqDec = iqDec + integer(@`IQ Decrease`);
				htDec = htDec + integer(@`HT Decrease`);
				fatDec = fatDec + integer(@`Fatigue Decrease`);
				hitsDec = hitsDec + integer(@`Hit Point Decrease`);
				deleteitem;
			endif
		endif
	endforeach

	if ($+inList(Disadvantages, Age))
		item (Disadvantages, "Age")
			if (stDec)
				ResetAtt("ST", $*~ST, $*&ST, stDec);
			endif
			if (dxDec)
				ResetAtt("DX", $*~DX, $*&DX, dxDec);
			endif
			if (iqDec)
				ResetAtt("IQ", $*~IQ, $*&IQ, iqDec);
			endif
			if (htDec)
				ResetAtt("HT", $*~HT, $*&HT, htDec);
			endif
			if (fatDec)
				if ($@~x_st = $@&x_st)
					Fatigue = 0;
				else
					Fatigue = $@~x_st + $@&x_st;
				endif
				option Fatigue Decrease = integer(optValue('Fatigue Decrease')) - fatDec;
				if (Fatigue = $@x_st)
					Main.x_st = Fatigue - fatDec;
				endif
			endif
			if (hitsDec)
				if ($@~x_ht = $@&x_ht)
					Fatigue = 0;
				else
					Fatigue = $@~x_ht + $@&x_ht;
				endif
				option Hit Point Decrease = integer(optValue('Hit Point Decrease')) - hitsDec;
				if (Hits = $@x_ht)
					Main.x_ht = Fatigue - hitsDec;
				endif
			endif
			option Last Age = age;
			if (age <= $*aging_age)
				deleteitem;
			endif
		enditem
	endif

	Information.Age = integer(age);
}
